﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;


namespace AZVIC.Ei8htPOS.DAL
{
    public class NETSHelperDB
    {
        public static NETSHelper.TransactionResponse GetItem(Guid NETSTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentNETSID", ((NETSTransactionResponseID != Guid.Empty && NETSTransactionResponseID != null) ? NETSTransactionResponseID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));

            return SQLHelper.RetrieveObject<NETSHelper.TransactionResponse>("spGetOrdersPaymentNETS", parameters);
        }

        public static List<NETSHelper.TransactionResponse> GetList(Guid NETSTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentNETSID", ((NETSTransactionResponseID != Guid.Empty && NETSTransactionResponseID != null) ? NETSTransactionResponseID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));

            return SQLHelper.RetrieveList<NETSHelper.TransactionResponse>("spGetOrdersPaymentNETS", parameters);
        }

        public static DataTable GetDataTable(Guid NETSTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentNETSID", ((NETSTransactionResponseID != Guid.Empty && NETSTransactionResponseID != null) ? NETSTransactionResponseID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));

            return SQLHelper.ExecuteDataTable("spGetOrdersPaymentNETS", parameters);
        }

        public static DataSet GetDataSet(Guid NETSTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentNETSID", ((NETSTransactionResponseID != Guid.Empty && NETSTransactionResponseID != null) ? NETSTransactionResponseID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));

            return SQLHelper.ExecuteDataSet("spGetOrdersPaymentNETS", parameters);
        }

        public static void Save(NETSHelper.TransactionResponse myTransaction)
        {
            myTransaction.Mode = ((myTransaction.UniqueID != Guid.Empty && myTransaction.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myTransaction.UniqueID = ((myTransaction.UniqueID != Guid.Empty && myTransaction.UniqueID != null) ? myTransaction.UniqueID : Guid.NewGuid());
            if (myTransaction.Mode == GlobalConfigurations.Mode.Insert)
            {
                myTransaction.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();

            parameters.Add(new SqlParameter("@OrdersPaymentNETSID", myTransaction.UniqueID));
            parameters.Add(new SqlParameter("@OrdersPaymentID", myTransaction.OrdersPaymentID));
            parameters.Add(new SqlParameter("@DeviceRequest", (string.IsNullOrEmpty(myTransaction.DeviceRequest) ? (object)DBNull.Value : myTransaction.DeviceRequest)));
            parameters.Add(new SqlParameter("@DeviceResponse", (string.IsNullOrEmpty(myTransaction.DeviceResponse) ? (object)DBNull.Value : myTransaction.DeviceResponse)));
            parameters.Add(new SqlParameter("@TransactionType", (string.IsNullOrEmpty(myTransaction.TransactionTypeVal.ToString()) ? (object)DBNull.Value : myTransaction.TransactionTypeVal.ToString())));
            parameters.Add(new SqlParameter("@IsApproved", myTransaction.IsApproved));
            parameters.Add(new SqlParameter("@ResponseText", string.IsNullOrEmpty(myTransaction.ResponseText) ? (object)DBNull.Value : myTransaction.ResponseText));
            parameters.Add(new SqlParameter("@MerchantName", string.IsNullOrEmpty(myTransaction.MerchantName) ? (object)DBNull.Value : myTransaction.MerchantName));
            parameters.Add(new SqlParameter("@BatchNumber", string.IsNullOrEmpty(myTransaction.BatchNumber) ? (object)DBNull.Value : myTransaction.BatchNumber));
            parameters.Add(new SqlParameter("@STAN", string.IsNullOrEmpty(myTransaction.STANval) ? (object)DBNull.Value : myTransaction.STANval));
            parameters.Add(new SqlParameter("@TransactionAmount", myTransaction.TransactionAmount == decimal.MinValue ? (object)DBNull.Value : myTransaction.TransactionAmount));
            parameters.Add(new SqlParameter("@TotalFee", myTransaction.TotalFee == decimal.MinValue ? (object)DBNull.Value : myTransaction.TotalFee));
            parameters.Add(new SqlParameter("@FeeDueToMerchant", myTransaction.FeeDueToMerchant == decimal.MinValue ? (object)DBNull.Value : myTransaction.FeeDueToMerchant));
            parameters.Add(new SqlParameter("@FeeDueFromMerchant", myTransaction.FeeDueFromMerchant == decimal.MinValue ? (object)DBNull.Value : myTransaction.FeeDueFromMerchant));
            parameters.Add(new SqlParameter("@CardNumber", string.IsNullOrEmpty(myTransaction.CardNumber) ? (object)DBNull.Value : myTransaction.CardNumber));
            parameters.Add(new SqlParameter("@ExpiryDate", myTransaction.ExpiryDate == DateTime.MinValue ? (object)DBNull.Value : myTransaction.ExpiryDate));
            parameters.Add(new SqlParameter("@RespMessage1", string.IsNullOrEmpty(myTransaction.RespMessage1) ? (object)DBNull.Value : myTransaction.RespMessage1));
            parameters.Add(new SqlParameter("@RespMessage2", string.IsNullOrEmpty(myTransaction.RespMessage2) ? (object)DBNull.Value : myTransaction.RespMessage2));
            parameters.Add(new SqlParameter("@PurchaseFee", myTransaction.PurchaseFee == decimal.MinValue ? (object)DBNull.Value : myTransaction.PurchaseFee));
            parameters.Add(new SqlParameter("@ApprovalCode", string.IsNullOrEmpty(myTransaction.ApprovalCode) ? (object)DBNull.Value : myTransaction.ApprovalCode));
            parameters.Add(new SqlParameter("@CardIssuerName", string.IsNullOrEmpty(myTransaction.CardIssuerName) ? (object)DBNull.Value : myTransaction.CardIssuerName));
            parameters.Add(new SqlParameter("@AdditionalTransactionInfo", string.IsNullOrEmpty(myTransaction.AdditionalTransactionInfo) ? (object)DBNull.Value : myTransaction.AdditionalTransactionInfo));
            parameters.Add(new SqlParameter("@RetrievalRefNumber", string.IsNullOrEmpty(myTransaction.RetreivalReferenceNo) ? (object)DBNull.Value : myTransaction.RetreivalReferenceNo));
            parameters.Add(new SqlParameter("@CEPASVersion", string.IsNullOrEmpty(myTransaction.CEPASVersion) ? (object)DBNull.Value : myTransaction.CEPASVersion));
            parameters.Add(new SqlParameter("@TDTransactionType", string.IsNullOrEmpty(myTransaction.TDTransactionType) ? (object)DBNull.Value : myTransaction.TDTransactionType));
            parameters.Add(new SqlParameter("@TDPostCardStatus", string.IsNullOrEmpty(myTransaction.TDPostCardStatus) ? (object)DBNull.Value : myTransaction.TDPostCardStatus));
            parameters.Add(new SqlParameter("@TDTransactionAmount", myTransaction.TDTransactionAmount == decimal.MinValue ? (object)DBNull.Value : myTransaction.TDTransactionAmount));
            parameters.Add(new SqlParameter("@TDTransactionDateTime", myTransaction.TDTransactionDate == DateTime.MinValue ? (object)DBNull.Value : myTransaction.TDTransactionAmount));
            parameters.Add(new SqlParameter("@TDPriorBalance", myTransaction.TDPriorBalance == decimal.MinValue ? (object)DBNull.Value : myTransaction.TDPriorBalance));
            parameters.Add(new SqlParameter("@TDPostBalance", myTransaction.TDPostBalance == decimal.MinValue ? (object)DBNull.Value : myTransaction.TDPostBalance));
            parameters.Add(new SqlParameter("@TDPostAutoLoad", myTransaction.TDPostAutoLoad == decimal.MinValue ? (object)DBNull.Value : myTransaction.TDPostAutoLoad));
            parameters.Add(new SqlParameter("@CardName", string.IsNullOrEmpty(myTransaction.CardName) ? (object)DBNull.Value : myTransaction.CardName));
            parameters.Add(new SqlParameter("@POSMessages", string.IsNullOrEmpty(myTransaction.POSMessages) ? (object)DBNull.Value : myTransaction.POSMessages));
            parameters.Add(new SqlParameter("@ServiceFee", myTransaction.ServiceFee == decimal.MinValue ? (object)DBNull.Value : myTransaction.TDPostCardStatus));
            parameters.Add(new SqlParameter("@MerchantID", (string.IsNullOrEmpty(myTransaction.MerchantID) ? (object)DBNull.Value : myTransaction.MerchantID)));
            parameters.Add(new SqlParameter("@TerminalID", (string.IsNullOrEmpty(myTransaction.TerminalID) ? (object)DBNull.Value : myTransaction.TerminalID)));
            parameters.Add(new SqlParameter("@CreatedBy", ((myTransaction.AdminUserAccountID != Guid.Empty && myTransaction.AdminUserAccountID != null) ? myTransaction.AdminUserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myTransaction.IsActive));

            SQLHelper.ExecuteQuery("spAddOrUpdateOrdersPaymentNETS", parameters);
        }
    }
}
